/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CDC.h,v 1.3 1999/10/06 06:41:00 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CDC_h	// [
#define Included_CDC_h

#include "pgpClassesConfig.h"

#include "CSize.h"
#include "CString.h"
#include "CWindow.h"

_PGP_BEGIN

// Class CDC

class CDC
{
	NOT_COPYABLE(CDC)

public:
	CDC(HDC dc = NULL);
	CDC(HWND hwnd, PGPBoolean includeNCArea = FALSE);
	~CDC();

	CDC&	operator=(HDC dc);

	operator HDC() const {return mDC;}

	HDC		DC() const {return mDC;}
	HDC		AttribDC() const {return mAttribDC;}
	HWND	Window() const {return mHWnd;}

	const PAINTSTRUCT&	PaintStruct() const {return mPaintStruct;}

	PGPBoolean	IsAttached() const {return IsntNull(mDC);}
	PGPBoolean	WeCreated() const {return mWeCreated;}
	PGPBoolean	WeGotFromWindow() const {return mWeGotFromWindow;}
	PGPBoolean	WeArePainting() const {return mWeArePainting;}

	void	FitStringToWidth(CString& cstr, PGPInt32 maxWidth) const;
	CSize	GetTextExtentPoint32(const char *str, PGPUInt32 length) const;
	CSize	GetTextExtentPoint32(const char *cstr) const;

	void	LPtoDP(PPOINT pPoints, PGPUInt32 numPoints = 1) const;
	void	DPtoLP(PPOINT pPoints, PGPUInt32 numPoints = 1) const;

	PGPBoolean	BitBlt(HDC hdcDest, PGPInt32 nXDest, PGPInt32 nYDest, 
		PGPInt32 width, PGPInt32 height, PGPInt32 nXSrc, PGPInt32 nYSrc, 
		PGPUInt32 dwRop) const
	{
		return ::BitBlt(hdcDest, nXDest, nYDest, width, height, DC(), nXSrc, 
			nYSrc, dwRop);
	}

	PGPBoolean	DrawFocusRect(const RECT& rect) const
	{
		return ::DrawFocusRect(DC(), &rect);
	}

	PGPBoolean	ExtTextOut(PGPInt32 X, PGPInt32 Y, PGPUInt32 options, 
		const RECT& rect, const char *string, PGPUInt32 strLength, 
		const PGPInt32 *pDx = NULL) const
	{
		return ::ExtTextOut(DC(), X, Y, options, &rect, string, strLength, 
			pDx);
	}

	void		FillRect(const RECT& rect, HBRUSH brush);

	PGPInt32	GetDeviceCaps(PGPInt32 index) const
	{
		return ::GetDeviceCaps(DC(), index);
	}

	PGPBoolean	GetTextMetrics(LPTEXTMETRIC pTM) const
	{
		return ::GetTextMetrics(DC(), pTM);
	}

	PGPBoolean	LineTo(PGPInt32 xEnd, PGPInt32 yEnd) const
	{
		return ::LineTo(DC(), xEnd, yEnd);
	}

	PGPBoolean	MoveToEx(PGPInt32 X, PGPInt32 Y, POINT *pPoint) const
	{
		return ::MoveToEx(DC(), X, Y, pPoint);
	}

	PGPBoolean	Rectangle(PGPInt32 left, PGPInt32 top, PGPInt32 right, 
		PGPInt32 bottom) const
	{
		return ::Rectangle(DC(), left, top, right, bottom);
	}

	// How cool is this?
	template <typename T> 
	T	SelectObject(T object) const
	{
		return static_cast<T>(::SelectObject(DC(), object));
	}

	HPALETTE	SelectPalette(HPALETTE palette, PGPBoolean forceBackground);
	PGPUInt32	RealizePalette();

	COLORREF	SetBkColor(COLORREF crColor) const
	{
		return ::SetBkColor(DC(), crColor);
	}

	COLORREF	SetTextColor(COLORREF crColor) const
	{
		return ::SetTextColor(DC(), crColor);
	}

	void	CreateCompatible(HDC dc);
	void	Attach(HDC dc);
	void	AttachFromWindow(HWND hwnd, PGPBoolean includeNCArea = FALSE);
	void	BeginPaint(HWND window);
	void	Clear();

private:
	HDC	mDC;
	HDC	mAttribDC;

	HWND		mHWnd;
	PAINTSTRUCT	mPaintStruct;

	PGPBoolean	mWeCreated;
	PGPBoolean	mWeGotFromWindow;
	PGPBoolean	mWeArePainting;
};

_PGP_END

#endif	// ] Included_CDC_h
